// Borland C++ Builder
// Copyright (c) 1995, 1998 by Borland International
// All rights reserved

// (DO NOT EDIT: machine generated header) 'AHMTStoreData.pas' rev: 3.00

#ifndef AHMTStoreDataHPP
#define AHMTStoreDataHPP
#include <Graphics.hpp>
#include <AHMSystemClass.hpp>
#include <Registry.hpp>
#include <IniFiles.hpp>
#include <Dialogs.hpp>
#include <Classes.hpp>
#include <Messages.hpp>
#include <Windows.hpp>
#include <SysUtils.hpp>
#include <SysInit.hpp>
#include <System.hpp>

//-- user supplied -----------------------------------------------------------

namespace Ahmtstoredata
{
//-- type declarations -------------------------------------------------------
enum TAHMRootKey { hkeyClassesRoot, hkeyCurrentUser, hkeyLocalMachine, hkeyUsers, hkeyCurrentConfig, 
	hkeyDynData };

enum TAHMDatatype { sRegistry, sIniFile };

class DELPHICLASS TAHMRegistry;
class PASCALIMPLEMENTATION TAHMRegistry : public Classes::TPersistent 
{
	typedef Classes::TPersistent inherited;
	
private:
	TAHMRootKey FRootKey;
	System::AnsiString FPath;
	void __fastcall SetPath(const System::AnsiString Value);
	
public:
	__fastcall TAHMRegistry(void);
	__fastcall virtual ~TAHMRegistry(void);
	
__published:
	__property TAHMRootKey Rootkey = {read=FRootKey, write=FRootKey, default=1};
	__property System::AnsiString Path = {read=FPath, write=SetPath};
};

class DELPHICLASS TAHMIniFile;
class PASCALIMPLEMENTATION TAHMIniFile : public Classes::TPersistent 
{
	typedef Classes::TPersistent inherited;
	
private:
	System::AnsiString FFilename;
	
public:
	__fastcall TAHMIniFile(void);
	__fastcall virtual ~TAHMIniFile(void);
	
__published:
	__property System::AnsiString IniFilename = {read=FFilename, write=FFilename};
};

class DELPHICLASS TAHMDataStore;
class PASCALIMPLEMENTATION TAHMDataStore : public Classes::TPersistent 
{
	typedef Classes::TPersistent inherited;
	
private:
	bool FEnabled;
	TAHMDatatype FDatatype;
	TAHMRegistry* FRegistry;
	TAHMIniFile* FIniFile;
	Classes::TNotifyEvent FOnError;
	System::AnsiString FSection;
	System::AnsiString FPassword;
	void __fastcall SetPassword(const System::AnsiString Value);
	
public:
	__fastcall TAHMDataStore(void);
	__fastcall virtual ~TAHMDataStore(void);
	
__published:
	__property Classes::TNotifyEvent OnError = {read=FOnError, write=FOnError};
	__property bool Enabled = {read=FEnabled, write=FEnabled, default=1};
	__property System::AnsiString Section = {read=FSection, write=FSection};
	__property System::AnsiString Password = {read=FPassword, write=SetPassword};
	__property TAHMDatatype Datatype = {read=FDatatype, write=FDatatype, default=0};
	__property TAHMRegistry* Registry = {read=FRegistry, write=FRegistry};
	__property TAHMIniFile* Inifile = {read=FIniFile, write=FIniFile};
};

class DELPHICLASS TAHMStoreData;
class PASCALIMPLEMENTATION TAHMStoreData : public Ahmsystemclass::TAHMSystemsComponent 
{
	typedef Ahmsystemclass::TAHMSystemsComponent inherited;
	
private:
	Classes::TNotifyEvent FOnError;
	TAHMDataStore* FDataStore;
	
public:
	__fastcall virtual TAHMStoreData(Classes::TComponent* AOwner);
	__fastcall virtual ~TAHMStoreData(void);
	System::AnsiString __fastcall ReadStr(System::AnsiString Key, System::AnsiString Error);
	System::Variant __fastcall ReadVariant(System::AnsiString Key, const System::Variant &Error);
	int __fastcall ReadInt(System::AnsiString Key, int Error);
	bool __fastcall ReadBool(System::AnsiString Key, bool Error);
	Graphics::TColor __fastcall ReadColor(System::AnsiString Key, Graphics::TColor Error);
	System::TDateTime __fastcall ReadTime(System::AnsiString Key, System::TDateTime Error);
	System::TDateTime __fastcall ReadDate(System::AnsiString Key, System::TDateTime Error);
	System::TDateTime __fastcall ReadDateTime(System::AnsiString Key, System::TDateTime Error);
	System::AnsiString __fastcall ReadCrypt(System::AnsiString Key, System::AnsiString Error);
	void __fastcall WriteCrypt(System::AnsiString Key, System::AnsiString Value);
	void __fastcall ReadStrs(Classes::TStringList* &Values);
	void __fastcall WriteTime(System::AnsiString Key, System::TDateTime Value);
	void __fastcall WriteDate(System::AnsiString Key, System::TDateTime Value);
	void __fastcall WriteDateTime(System::AnsiString Key, System::TDateTime Value);
	void __fastcall WriteVariant(System::AnsiString Key, const System::Variant &Value);
	void __fastcall WriteStr(System::AnsiString Key, System::AnsiString Value);
	void __fastcall WriteInt(System::AnsiString Key, int Value);
	void __fastcall WriteColor(System::AnsiString Key, Graphics::TColor Value);
	void __fastcall WriteBool(System::AnsiString Key, bool Value);
	void __fastcall DeleteKey(System::AnsiString Key);
	void __fastcall Erase(void);
	
__published:
	__property Classes::TNotifyEvent OnError = {read=FOnError, write=FOnError};
	__property TAHMDataStore* DataStore = {read=FDataStore, write=FDataStore};
};

//-- var, const, procedure ---------------------------------------------------
extern PACKAGE HKEY AHMHKeys[6];

}	/* namespace Ahmtstoredata */
#if !defined(NO_IMPLICIT_NAMESPACE_USE)
using namespace Ahmtstoredata;
#endif
//-- end unit ----------------------------------------------------------------
#endif	// AHMTStoreData
